/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.converter;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DataConverterNbt {
    @Nullable
    public static BaseData fromVanillaNbt(Tag vanillaTag) {
        switch (vanillaTag.getId()) {
            case 1: {
                return new ByteData(((ByteTag)vanillaTag).value());
            }
            case 2: {
                return new ShortData(((ShortTag)vanillaTag).value());
            }
            case 3: {
                return new IntData(((IntTag)vanillaTag).value());
            }
            case 4: {
                return new LongData(((LongTag)vanillaTag).value());
            }
            case 5: {
                return new FloatData(((FloatTag)vanillaTag).value());
            }
            case 6: {
                return new DoubleData(((DoubleTag)vanillaTag).value());
            }
            case 8: {
                return new StringData(((StringTag)vanillaTag).value());
            }
            case 7: {
                return new ByteArrayData(((ByteArrayTag)vanillaTag).getAsByteArray());
            }
            case 11: {
                return new IntArrayData(((IntArrayTag)vanillaTag).getAsIntArray());
            }
            case 12: {
                return new LongArrayData(((LongArrayTag)vanillaTag).getAsLongArray());
            }
            case 10: {
                return DataConverterNbt.fromVanillaCompound(vanillaTag.asCompound().orElse(new CompoundTag()));
            }
            case 9: {
                return DataConverterNbt.fromVanillaList(vanillaTag.asList().orElse(new ListTag()));
            }
        }
        MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaCompound: Unknown NBT tag id {}", (Object)vanillaTag.getId());
        return null;
    }

    public static ListData fromVanillaList(ListTag vanillaList) {
        ListData list = new ListData();
        if (vanillaList == null || vanillaList.isEmpty()) {
            return list;
        }
        for (int index = 0; index < vanillaList.size(); ++index) {
            Tag entry = (Tag)vanillaList.get(index);
            if (entry == null) continue;
            if (entry.getId() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return list;
            }
            BaseData convertedTag = DataConverterNbt.fromVanillaNbt(entry);
            if (convertedTag == null) continue;
            list.add(convertedTag);
        }
        return list;
    }

    public static CompoundData fromVanillaCompound(CompoundTag vanillaCompound) {
        CompoundData data = new CompoundData();
        if (vanillaCompound == null || vanillaCompound.isEmpty()) {
            return data;
        }
        for (String key : vanillaCompound.keySet()) {
            BaseData convertedTag;
            Tag ele = vanillaCompound.get(key);
            if (ele == null || (convertedTag = DataConverterNbt.fromVanillaNbt(ele)) == null) continue;
            data = data.put(key, convertedTag);
        }
        return data;
    }

    @Nullable
    public static Tag toVanillaNbt(BaseData data) {
        switch (data.getType()) {
            case 1: {
                return ByteTag.valueOf((byte)((ByteData)data).value);
            }
            case 2: {
                return ShortTag.valueOf((short)((ShortData)data).value);
            }
            case 3: {
                return IntTag.valueOf((int)((IntData)data).value);
            }
            case 4: {
                return LongTag.valueOf((long)((LongData)data).value);
            }
            case 5: {
                return FloatTag.valueOf((float)((FloatData)data).value);
            }
            case 6: {
                return DoubleTag.valueOf((double)((DoubleData)data).value);
            }
            case 8: {
                return StringTag.valueOf((String)((StringData)data).value);
            }
            case 7: {
                return new ByteArrayTag(((ByteArrayData)data).value);
            }
            case 11: {
                return new IntArrayTag(((IntArrayData)data).value);
            }
            case 12: {
                return new LongArrayTag(((LongArrayData)data).value);
            }
            case 10: {
                return DataConverterNbt.toVanillaCompound((CompoundData)data);
            }
            case 9: {
                return DataConverterNbt.toVanillaList((ListData)data);
            }
        }
        MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaNbt: Unknown NBT tag id {}", (Object)data.getType());
        return null;
    }

    public static ListTag toVanillaList(ListData listData) {
        ListTag list = new ListTag();
        if (listData == null || listData.isEmpty()) {
            return list;
        }
        for (int index = 0; index < listData.size(); ++index) {
            BaseData entry = listData.get(index);
            if (entry == null) continue;
            if (entry.getType() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return list;
            }
            Tag convertedTag = DataConverterNbt.toVanillaNbt(entry);
            if (convertedTag == null) continue;
            list.add((Object)convertedTag);
        }
        return list;
    }

    public static CompoundTag toVanillaCompound(CompoundData compoundData) {
        CompoundTag tag = new CompoundTag();
        for (String key : compoundData.getKeys()) {
            BaseData data = compoundData.getData(key).orElse(null);
            if (data == null) continue;
            Tag convertedTag = DataConverterNbt.toVanillaNbt(data);
            if (convertedTag == null) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaCompound:B: Got a null tag in a compound with key {}", (Object)key);
                continue;
            }
            tag.put(key, convertedTag);
        }
        return tag;
    }
}

